//tsc "C:\Users\axeld\Documents\Projects\Projects_Programming\website_parser\build\local\html\shared\javascript\website\website_shared.ts" --skipLibCheck --module none --lib es2020,dom --target ES2020 --pretty false
const HIDDEN_CLASS = "hidden";
const DISPLAY_CLASS = "displayed";
const LOCKED_CLASS = "locked";
const ORPHAN_CLASS = "orphan";
const SELECTED_CLASS = "sel";
const HIGHLIGHT_CLASS = "highl";
let TOOL_TIP_DISPLAYED: DOM_Element|null = null; 
let   mouseX = 0;
let   mouseY = 0

document.addEventListener('mousemove', (event) => 
{
  mouseX = event.clientX; 
  mouseY = event.clientY; 
});

window.addEventListener("scroll", () => 
{
  if(TOOL_TIP_DISPLAYED !== null)
  {
    if(DOM_Remove(TOOL_TIP_DISPLAYED, UI_StatusNotFlags.NONE))
    {
      TOOL_TIP_DISPLAYED = null;
    }
  }
});

const ui_global: UI_Root = 
{
  root:          {} as DOM_Element,
  top_left:      {} as DOM_Element,
  top_right:     {} as DOM_Element,
  bottom_left:   {} as DOM_Element,
  bottom_right:  {} as DOM_Element,
  top_bar:       {} as DOM_Element,
  dom_elements:  [],
};
IDK_ExtractIdentifiers();
let html_elements: HTMLElement[] = [];
const ommit = ["top", "body_wrapper", "ui_root", "ui_top_left", "ui_top_right","ui_bottom_right","ui_bottom_left"]
document.addEventListener("DOMContentLoaded", () => 
{
  /* NOTE: Order permit the codepath to avoid useless checks later and must be kept order until the Update() is done
          We still have duplicates in the array of query selectors but don't care, global internal dom elements will not be duplicated
  */
  const body = document.getElementById(IDK_HTMLStringFromKind(DOM_ElementTypes_Body)) as HTMLElement;
  html_elements = html_elements.concat(body);
  const toc = document.getElementById('toc') as HTMLElement;
  html_elements = html_elements.concat(toc);
  const doc_context = document.getElementById(IDK_HTMLStringFromKind(DOM_ElementTypes_ContextDocument)) as HTMLElement;
  html_elements = html_elements.concat(doc_context);
  const contexts = Array.from(document.querySelectorAll(`[id^="${IDK_HTMLStringFromKind(DOM_ElementTypes_Context)}"]`)) as HTMLElement[];
  html_elements = html_elements.concat(contexts);
  const internal_links = Array.from(document.querySelectorAll(`[id^="${IDK_HTMLStringFromKind(DOM_ElementTypes_InternalLink)}"]`)) as HTMLElement[];
  html_elements = html_elements.concat(internal_links);
  const http_links = Array.from(document.querySelectorAll(`[id^="${IDK_HTMLStringFromKind(DOM_ElementTypes_HTTPLink)}"]`)) as HTMLElement[];
  html_elements = html_elements.concat(http_links);
  const file_links = Array.from(document.querySelectorAll(`[id^="${IDK_HTMLStringFromKind(DOM_ElementTypes_FileLink)}"]`)) as HTMLElement[];
  html_elements = html_elements.concat(file_links);
  const broken_links = Array.from(document.querySelectorAll(`[id^="${IDK_HTMLStringFromKind(DOM_ElementTypes_BrokenLink)}"]`)) as HTMLElement[];
  html_elements = html_elements.concat(broken_links);
  const blocks = Array.from(document.querySelectorAll(`[id^="${IDK_HTMLStringFromKind(DOM_ElementTypes_Block)}"]`)) as HTMLElement[];
  html_elements = html_elements.concat(blocks);
  const paragraphs = Array.from(document.querySelectorAll("p")) as HTMLElement[];
  html_elements = html_elements.concat(paragraphs);
  html_elements = html_elements.filter((element): element is HTMLElement => element !== null);
  Update();
});

function IDK_ExtractIdentifiers()
{
  const metas = Array.from(document.querySelectorAll("meta"));
  const result: {id: string, kind_name: string, flag: string}[] = new Array(metas.length);
  for(let idx = 0; idx < metas.length; idx += 1)
  {
    if(metas[idx].classList.contains("idk_identifier"))
    {
      result[idx] = { id: metas[idx].name, kind_name: metas[idx].content, flag: metas[idx].getAttribute("data-flag") as string};
    }
  }
  
}

function DOM_SetStyleForTags(elements) 
{
  for(let idx = 0; idx < elements.length; idx += 1)
  {
    const el: HTMLElement = elements[idx];
    let blocked = false;
    for(let idx = 0; idx < ommit.length; idx += 1)
    {
      if(el.id === ommit[idx])
      {
        blocked = true;
      }
    }
    if(!blocked)
    {
    }
  } 
}

let x_ray: null | DOM_Element = null;

function Update()
{
  ///////////////////////////////////////////////////////////////////////////
  // UX layout initialization
  
  // top bar
  const top_element = document.querySelector("#top") as HTMLElement;
  ui_global.top_bar = DOM_PushElem(null, DOM_ElementTypes_TopBar, ["top_bar"]);
  DOM_Append(ui_global.top_bar.el, top_element, DOM_AppendType.LastChild);
  // top left
  {
    ui_global.top_left = DOM_PushElem(null, DOM_ElementTypes_TopMost, ["#ui_top_left"]);
    if(top_element !== null)
    {
      DOM_Append(ui_global.top_left.el, top_element, DOM_AppendType.LastChild);
    }
    UI_Display(ui_global!.top_left)
  }
  // top right
  {
    ui_global.top_right = DOM_PushElem(null, DOM_ElementTypes_TopMost, ["#ui_top_right"]);
    if(top_element)
    {
      DOM_Append(ui_global.top_right.el, top_element, DOM_AppendType.LastChild);
    }
  }
  {
  // bottom right
    ui_global.bottom_right = DOM_PushElem(null, DOM_ElementTypes_TopMost, ["#ui_bottom_right"]);
    if(top_element)
    {
      DOM_Append(ui_global.bottom_right.el, top_element, DOM_AppendType.LastChild);
      x_ray = DOM_PushElem(null, DOM_ElementTypes_Trigger, ["x_ray"]);
      DOM_Append(x_ray.el, ui_global.bottom_right.el, DOM_AppendType.LastChild);
    }
  }
  // bottom left
  ui_global.bottom_left = DOM_PushElem(null, DOM_ElementTypes_TopMost, ["#ui_bottom_left"]);
  if(top_element)
  {
    DOM_Append(ui_global.bottom_left.el, top_element, DOM_AppendType.LastChild);
  }
  /////////////////////////////////////////////////////////
  // internal DOM_Elements initialization
  
  DOM_CreationFromHTMLNodes(html_elements, ui_global);
}

function DOM_IsPresent(el: HTMLElement): boolean 
{
  return document.contains(el);
}

function DOM_IsClassNamePresent(class_name: string): boolean 
{
  return document.querySelector('.' + class_name) !== null;
}

function IDK_DOMElementsFromIDXs(idxs: number[]): DOM_Element[]
{
  const elements = ui_global.dom_elements.filter((_, index) =>
    idxs.includes(index)
  );
  return elements
}

function DOM_Remove(dom_el: DOM_Element, status_not: UI_StatusNotFlags): boolean
{
  let result = false;
  if(UI_CanModify(dom_el.ui_status, status_not))
  {
    if(dom_el.el && dom_el.el.parentElement)
    {
      dom_el.el.parentElement.removeChild(dom_el.el);
      if(dom_el.types & DOM_ElementTypes_ToolTip && 
         TOOL_TIP_DISPLAYED !== null)
      {
        TOOL_TIP_DISPLAYED = null;
      }
      UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.Orphan|UI_Status.Hidden, UI_StatusNotFlags.NONE);
      result = true;
      dom_el!.ui_status |= UI_Status.Orphan;
    }
  }
  return result;
}


/////////////////////////////////////////
// init

function DOM_CreationFromHTMLNodes(html_elements: HTMLElement[], ui: UI_Root)
{
  if(ui.top_right === null || ui.top_left === null) return;
  for(let idx = 0; idx < html_elements.length; idx += 1)
  {
    const html_el = html_elements[idx]
    const types = IDK_DeriveType(html_el);
    if(types & DOM_ElementTypes_ContextDocument && !UIGLOBAL_HasElement(html_el))
    {
      const dom_el = DOM_PushElem(html_el, types, []);
      const open_document_context = DOM_PushElem(null, DOM_ElementTypes_Trigger, []);
      DOM_Remove(dom_el, UI_StatusNotFlags.NONE);
      DOM_AppendElement(open_document_context, ui.top_right, DOM_AppendType.LastChild);
      open_document_context.el.addEventListener("click", () => 
      {
        if(dom_el.ui_status & UI_Status.Orphan)
        {
          DOM_AppendElement(dom_el, ui.top_right, DOM_AppendType.LastChild);
          UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.Displayed, UI_StatusNotFlags.NONE);
        }
        else
        {
          DOM_Remove(dom_el, UI_StatusNotFlags.NONE);
          UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.Hidden, UI_StatusNotFlags.NONE);
        }
      });
    }
    if(types & DOM_ElementTypes_Text)
    {
      const dom_el = DOM_PushElem(html_el, types, []);
    }
    if(types & DOM_ElementTypes_TOC)
    {
      const dom_el = DOM_PushElem(html_el, types, []);
      DOM_Remove(dom_el, UI_StatusNotFlags.NONE);
      const open_toc = DOM_PushElem(null, DOM_ElementTypes_Trigger, []);
      DOM_AppendElement(open_toc, ui.top_right, DOM_AppendType.LastChild);
      open_toc.el.addEventListener("click", () => 
      {
        if(dom_el.ui_status & UI_Status.Orphan)
        {
          DOM_AppendElement(dom_el, ui.top_right, DOM_AppendType.LastChild);
          UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.Displayed, UI_StatusNotFlags.NONE);
        }
        else
        {
          DOM_Remove(dom_el, UI_StatusNotFlags.NONE);
          UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.Hidden, UI_StatusNotFlags.NONE);
        }
      });
    }
    if(types & DOM_ElementTypes_InternalLink)
    {
    }
    if(types & DOM_ElementTypes_Heading1 ||
      types & DOM_ElementTypes_Heading2  ||
      types & DOM_ElementTypes_Heading3  ||
      types & DOM_ElementTypes_Heading4  ||
      types & DOM_ElementTypes_Heading5)
    {
      DOM_PushElem(html_el, types, []);
    }
    if(types & DOM_ElementTypes_Link && !UIGLOBAL_HasElement(html_el))
    {
      const dom_el = DOM_PushElem(html_el, types, []);
      const link_tooltip = DOM_PushElem(null, DOM_ElementTypes_ToolTip, []);
      link_tooltip.el.innerHTML = `${(dom_el.el as HTMLAnchorElement).href}`
      UI_PushLink(dom_el, link_tooltip, UI_ElementLinkType.LinkSnapToParent)
      DOM_ElementPushActions(dom_el,
      [
        {extra_after: null, extra_before: null, on_types: DOM_ElementTypes_ToolTip, selects: DOM_SelectTypes_AllBrokenLink,  event_type: EVENT_Type.MouseEnter, type: IDK_ActionType.ToolTip, event: null },
        {extra_after: null, extra_before: null, on_types: DOM_ElementTypes_ToolTip, selects: DOM_SelectTypes_AllBrokenLink,  event_type: EVENT_Type.MouseLeave, type: IDK_ActionType.ToolTip, event: null },
      ]);
      IDK_StartListeners(dom_el);
    }
    if(types & DOM_ElementTypes_BrokenLink && !UIGLOBAL_HasElement(html_el))
    {
      const broken_link = DOM_PushElem(html_el, DOM_ElementTypes_BrokenLink, []);// not anchor but span
      const link_tooltip = DOM_PushElem(null, DOM_ElementTypes_ToolTip, []);
      UI_PushLink(broken_link, link_tooltip, UI_ElementLinkType.LinkSnapToParent)
      link_tooltip.el.innerHTML = broken_link.el.innerText;
      DOM_ElementPushActions(broken_link,
      [
        {extra_after: null, extra_before: null, on_types: DOM_ElementTypes_ToolTip, selects: DOM_SelectTypes_AllChildrens,  event_type: EVENT_Type.MouseEnter, type: IDK_ActionType.ToolTip, event: null },
        {extra_after: null, extra_before: null, on_types: DOM_ElementTypes_ToolTip, selects: DOM_SelectTypes_AllChildrens,  event_type: EVENT_Type.MouseLeave, type: IDK_ActionType.ToolTip, event: null },
      ]);
      IDK_StartListeners(broken_link);
    }    
    if(types & DOM_ElementTypes_Link)
    {
      
    }
    if(types & DOM_ElementTypes_Body)
    {
      DOM_PushElem(html_el, types, []);
    }
    if(types & DOM_ElementTypes_InternalLink)
    {
      DOM_PushElem(html_el, types, []);
    }
    if(types & DOM_ElementTypes_Heading1 ||
       types & DOM_ElementTypes_Heading2 ||
       types & DOM_ElementTypes_Heading3 ||
       types & DOM_ElementTypes_Heading4 ||
       types & DOM_ElementTypes_Heading5)
    {
      const dom_el = DOM_PushElem(html_el, types, []);
    }
    if(types & DOM_ElementTypes_Block)
    {
      const dom_el = DOM_PushElem(html_el, types|DOM_ElementTypes_Selectable, []);
      dom_el.el.addEventListener("mouseenter", () => 
      {
        UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.Selected, UI_StatusNotFlags.NONE);
      });
      dom_el.el.addEventListener("click", () => 
      {
        UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.Highlighted, UI_StatusNotFlags.NONE);
        navigator.clipboard.writeText(dom_el.el.innerHTML).then(() => {}).catch(_ => {});
        setTimeout(() => 
        {
          UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.UnHighlighted, UI_StatusNotFlags.NONE);
        }, 80);
      });
      dom_el.el.addEventListener("mouseleave", () => 
      {
        UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.UnSelected, UI_StatusNotFlags.NONE);
      });
    }
    if(types & DOM_ElementTypes_Image)
    {
    }
    if(types & DOM_ElementTypes_TOCItem)
    {
      const dom_el = DOM_PushElem(html_el, types|DOM_ElementTypes_Selectable, []);
    }
    if(types & DOM_ElementTypes_Context && !UIGLOBAL_HasElement(html_el))
    {
      const dom_el = DOM_PushElem(html_el, types|DOM_ElementTypes_Context|DOM_ElementTypes_ToolTip, []);      
    }
  }
  if(x_ray)
  {
    DOM_ElementPushActions(x_ray,
    [
      {extra_after: null, extra_before: null, on_types: DOM_ElementTypes_ParentContext, selects: DOM_SelectTypes_All,  event_type: EVENT_Type.MouseClick, type: IDK_ActionType.HoverVisualsHighlight, event: null },
    ]);
    for(let idx = 0; idx < ui_global.dom_elements.length; idx += 1)
    {
      if(ui_global.dom_elements[idx].types & DOM_ElementTypes_ParentContext)
      {
        
        UI_PushLink(x_ray, ui_global.dom_elements[idx], UI_ElementLinkType.Display) // TODO: link type is wrong
        IDK_StartListeners(x_ray);
      }
      }
    }
}

function DOM_AppendElement(dom_el: DOM_Element|null, 
                          onto: DOM_Element|null, 
                          append_type: DOM_AppendType): boolean
{
  let result = true;
  if(dom_el === null || onto === null)
  {
    result = false;
  }
  // remove the current tooltip displayed on screen before appending the new one
  if(dom_el!.types & DOM_ElementTypes_ToolTip && 
     TOOL_TIP_DISPLAYED !== null)
  {
    if(!DOM_Remove(TOOL_TIP_DISPLAYED, UI_StatusNotFlags.NONE))
    {
      TOOL_TIP_DISPLAYED = null;
      result = false;
    }
  }
  if(result === true)
  {
    result = DOM_Append(dom_el!.el, onto!.el, DOM_AppendType.LastChild);
    if(dom_el!.types & DOM_ElementTypes_ToolTip)
    {
      TOOL_TIP_DISPLAYED = dom_el;
    }
    dom_el!.ui_status &= ~UI_Status.Orphan;
  }
  
  return result;
}


function DOM_GetFirstChildByType(parent: HTMLElement|null,
                                 types: bigint): HTMLElement|SVGSVGElement|null
{
  let result: HTMLElement|SVGSVGElement|null = null;
  if(parent !== null)
  {
    for(let idx = 0; idx < parent.childNodes.length; idx += 1)
    {
      const child = parent.childNodes[idx];
      if(child instanceof HTMLElement ||
        child instanceof SVGSVGElement)
      {
        const child_types = IDK_DeriveType(child);
        if(types & child_types)
        {
          result = child;
          break;
        }
      }
    }
  }
  return result;
}
function DOM_Append(el: HTMLElement|null,
                    onto: HTMLElement, 
                    append_type: DOM_AppendType): boolean
{
  // TODO: Implement if Status.Locked
  let good = true;
  if(el === null || el!.parentElement)
  {
    good = false;
  }
  if(good)
  {
    switch(append_type)
    {
      case DOM_AppendType.After:
      {
        if(onto.parentNode)
        {
          onto.parentNode.insertBefore(el as HTMLElement, onto.nextSibling);
          good = true;
        }
      } break;
      case DOM_AppendType.Before:
      {
        if(onto.parentNode)
        {
          onto.parentNode.insertBefore(el as HTMLElement, onto);
          good = true;
        }
      } break;
      case DOM_AppendType.FirstChild:
      {
        let before = onto.firstChild;
        if(before)
        {
          onto.insertBefore(el as HTMLElement, before);
        }
        else
        {
          onto.appendChild(el as HTMLElement);
        }
        good = true;
      } break;
      case DOM_AppendType.NULL:
      case DOM_AppendType.LastChild:
      {
        onto.appendChild(el as HTMLElement);
        good = true;
      } break;
    }
    el?.classList.remove(ORPHAN_CLASS);
  }
  return good;
}

function DOM_ElementPushActions(dom_el: DOM_Element, actions: IDK_Action[])
{
    dom_el.actions.push(...actions);
}

function DOM_SetClassNamesFromTypes(el: HTMLElement, selects: bigint, 
                                    types: bigint)
{
  let class_names: string[] = [];
  if(types & DOM_ElementTypes_Data)
  {
    class_names.push("data");
  }
  if(selects & DOM_ElementTypes_Context)
  {
    class_names.push("context");
  }
  if(selects & DOM_ElementTypes_Trigger)
  {
    class_names.push("trigger");
  }
  if(selects & DOM_SelectTypes_Self)
  {
    el.classList.add(...class_names);
  }
  else if(selects & DOM_SelectTypes_AllChildrens)
  {
    el.childNodes.forEach(children =>
    {
      if(children instanceof HTMLElement) 
      {
        children.classList.add(...class_names);
      }
    })
  }
  else
  {
    if(selects & DOM_SelectTypes_All)
    {
      el.classList.add(...class_names);
    }
    el.childNodes.forEach((el) => 
    {
      if(el instanceof HTMLElement) 
      {
        if(selects & DOM_SelectTypes_AllData && el.classList.contains("data")) 
        {
            el.classList.add(...class_names)
        }
        else if(selects & DOM_SelectTypes_AllTrigger && el.classList.contains("trigger")) 
        {
            el.classList.add(...class_names)
        }
      }
    });
  }
}
//////////////////
// status modifiers

function UI_Hide(dom_el: DOM_Element)
{
  dom_el.el.classList.add(HIDDEN_CLASS)
  dom_el.el.classList.remove(DISPLAY_CLASS)
  dom_el.ui_status &= ~UI_Status.Displayed
  dom_el.ui_status |= UI_Status.Hidden
}

function UI_Display(dom_el: DOM_Element)
{
  dom_el.el.classList.remove(HIDDEN_CLASS)
  dom_el.ui_status &= ~UI_Status.Hidden
  dom_el.ui_status |= UI_Status.Displayed
}

function UI_Lock(dom_el: DOM_Element)
{
  dom_el.el.classList.add(LOCKED_CLASS)
  dom_el.ui_status |= UI_Status.Locked
}

function UI_Unlock(dom_el: DOM_Element)
{
  dom_el.el.classList.remove(LOCKED_CLASS)
  dom_el.ui_status &= ~UI_Status.Locked
}

function UI_MakeOrphan(dom_el: DOM_Element)
{
  dom_el.el.classList.add(ORPHAN_CLASS)
  dom_el.ui_status |= UI_Status.Orphan
}

function UI_UnOrphan(dom_el: DOM_Element)
{
  dom_el.el.classList.remove(ORPHAN_CLASS)
  dom_el.ui_status &= ~UI_Status.Orphan
}

function UI_Select(dom_el: DOM_Element)
{
  dom_el.el.classList.add(SELECTED_CLASS)
  dom_el.ui_status |= UI_Status.Selected
}

function UI_UnSelect(dom_el: DOM_Element)
{
  dom_el.el.classList.remove(SELECTED_CLASS)
  dom_el.ui_status &= ~UI_Status.Selected
}

function UI_Highlight(dom_el: DOM_Element)
{
  dom_el.el.classList.add(HIGHLIGHT_CLASS)
  dom_el.ui_status |= UI_Status.Highlighted
}

function UI_UnHighlight(dom_el: DOM_Element)
{
  dom_el.el.classList.remove(HIGHLIGHT_CLASS)
  dom_el.ui_status &= ~UI_Status.Highlighted
}

function UI_SetDisplay(dom_el: DOM_Element, selects: bigint, 
                      status: UI_Status, status_not: UI_StatusNotFlags)
{
  if(dom_el.ui_status & UI_Status.Locked    && 
     status_not & UI_StatusNotFlags.NotLocked)
  {
  }
  else if(selects & DOM_SelectTypes_Self ||
          selects & DOM_SelectTypes_All)
  {
    if(status & UI_Status.Unlocked)
    {
      UI_Unlock(dom_el);
    }
    else if(status & UI_Status.Locked)
    {
      UI_Lock(dom_el);
    }
    if(status & UI_Status.Orphan)
    {
      UI_MakeOrphan(dom_el);
    }
    else if(status & UI_Status.UnOrphan)
    {
      UI_UnOrphan(dom_el);
    }
    if(status & UI_Status.Hidden)
    {
      UI_Hide(dom_el);
    }
    else if(status & UI_Status.Displayed)
    {
      UI_Display(dom_el);
    }
    if(status & UI_Status.Selected)
    {
      UI_Select(dom_el);
    }
    else if(status & UI_Status.UnSelected)
    {
      UI_UnSelect(dom_el);
    }
    if(status & UI_Status.Highlighted)
    {
      UI_Highlight(dom_el);
    }
    else if(status & UI_Status.UnHighlighted)
    {
      UI_UnHighlight(dom_el);
    }
  }  
  if(selects & DOM_SelectTypes_All)
  {
    for(let idx = 0; idx < dom_el.links.length; idx += 1)
    {
      const html_child_n = dom_el.links[idx]
      if(html_child_n instanceof HTMLElement)
      {
        UI_SetDisplay(html_child_n.dom_el, DOM_SelectTypes_Self, status, status_not);
      }
    }
  }
}

////////////////////////////////////////////////////////////
// actions

function IDK_DOMEventFromActionType(type: EVENT_Type)
{
  let result = "";
  switch(type)
  {
    case EVENT_Type.MouseClick:
    {
      result = "click";
    } break;
    case EVENT_Type.MouseEnter:
    {
      result = "mouseenter";
    } break;
    case EVENT_Type.MouseLeave:
    {
      result = "mouseleave";
    } break;
    case EVENT_Type.MouseRightClick:
    {
      result = "contextmenu";
    } break;
  }
  return result;
}

function UI_ApplyAction(func: ((...args: any[]) => any), 
                               dom_el: DOM_Element, action: IDK_Action)
{
  if(action.selects &  DOM_SelectTypes_All ||
    action.selects & DOM_SelectTypes_Self)
  {
    if(dom_el.types & action.on_types)
    {
      func(dom_el, action.selects)
    }
  }
  if(action.selects &  DOM_SelectTypes_AllChildrens ||
     action.selects &  DOM_SelectTypes_All)
  {
    for(let idx = 0; idx < dom_el.links.length; idx += 1)
    {
      const link: UI_ElementLink = dom_el.links[idx]; 
      if(action.on_types & link.dom_el.types)
      {
        func(link.dom_el, action.selects)
      }
    }
  }
}

function IDK_ActionsByTypes(dom_el: DOM_Element, types: IDK_ActionType)
{
  let result: IDK_Action[] = [];
  for(let idx = 0; idx < dom_el.actions.length; idx += 1)
  {
    const action = dom_el.actions[idx];
    if(action.type & types)
    {
      result.push(action);
    }
  }
  return result
}

function IDK_LinkByLinkTypes(dom_el: DOM_Element, types: UI_ElementLinkType): UI_ElementLink[]
{
  let result: UI_ElementLink[] = [];
  for(let idx = 0; idx < dom_el.links.length; idx += 1)
  {
    const link = dom_el.links[idx];
    if(link.type & types)
    {
      result.push(link);
    }
  }
  return result
}

function IDK_PopListeners(dom_el: DOM_Element, actions: IDK_Action[])
{
  const keep: IDK_Action[] = [];
  for(let idx_action = 0; idx_action < dom_el.actions.length; idx_action += 1)
  {
    const action = actions[idx_action];
    if(action?.event && actions.includes(action))
    {
      const event_str = IDK_DOMEventFromActionType(action.event_type);
      removeEventListener(event_str, action.event.func);
    }
    else
    {
      keep.push(action)
    }
  }
  dom_el.actions = keep;
}

function IDK_CreateIDKFunction(func: (...args: any[]) => any, el: HTMLElement, action: IDK_Action):IDK_EventFunction
{
  const idk_func: IDK_EventFunction = {func: func };
  return idk_func;
}

function IDK_StartListeners(dom_el: DOM_Element)
{
  for(let idx = 0; idx < dom_el.actions.length; idx += 1)
  {
    const action = dom_el.actions[idx];
    if(!action.event?.func)
    {
      let func:  ((...args: any[]) => any)|null  = null;
      if(action.type === IDK_ActionType.WipeData)
      {
      }
      else if(action.type === IDK_ActionType.WipeAll)
      {
        func = (event, dom_el, action) => IDK_ActionPutWipeAll(event, dom_el, action);
      }     
      else if(action.type === IDK_ActionType.CopyText)
      {
        func = (event, dom_el, action) => IDK_ActionCopy(event, dom_el, action);
      }     
      else if(action.type === IDK_ActionType.Overlay)
      {
        func = (event, dom_el, action) => IDK_ActionOverlay(event, dom_el, action);
      }     
      else if(action.type === IDK_ActionType.SnapElementToggle || 
              action.type === IDK_ActionType.PopDownElement    ||
              action.type === IDK_ActionType.PopUpElement)
      {
        func = (event, dom_el, action) => IDK_ActionPutSnapTo(event, dom_el, action);
      } 
      else if(action.type === IDK_ActionType.ToolTip)
      {
        func = (event, dom_el, action) => IDK_ActionToolTip(event, dom_el, action);
      }      
      else if(action.type === IDK_ActionType.Pressed ||
              action.type === IDK_ActionType.PressedHold)
      {
        func = (event, dom_el, action) => IDK_ActionPutPressed(event, dom_el, action);
      }      
      else if(action.type === IDK_ActionType.HoverVisualsHighlight)
      {
        func = (event, dom_el, action) => IDK_ActionPutVisualsHighligh(event, dom_el, action);
      }
      else if(action.type === IDK_ActionType.HoverVisualsSelected)
      {
        func = (event, dom_el, action) => IDK_ActionPutVisualsUnselected(event, dom_el, action);
      }
      else if(action.type === IDK_ActionType.ScrollTo)
      {
        func = (event, dom_el, action) => IDK_ActionPutScrollTo(event, dom_el, action);
      }
      const event_str = IDK_DOMEventFromActionType(action.event_type);
      if(dom_el.el && func)
      {
        dom_el.el.addEventListener(event_str, (event)=> func(event, dom_el, action));
        action.event = ({func: func, type: action.event_type});
      }
    }
  }
}

///////////////////////////////////////////////////
// actions

// snap
function IDK_ActionOverlay(event: Event, dom_el: DOM_Element, action: IDK_Action)
{
  UI_ApplyAction(UI_ActionHighlight, dom_el, action);
}

function IDK_ActionPutSnapTo(event: Event, dom_el: DOM_Element, action: IDK_Action)
{
  let links = dom_el.links;
  if(action.extra_before)
  {
    links = action.extra_before(dom_el, action);
  }
  if(action.type === IDK_ActionType.PopUpElement)
  {
    UI_ApplyAction(UI_ActionSnap, dom_el, action);
  }
  else if(action.type === IDK_ActionType.PopDownElement)
  {
    UI_ActionUnSnap(dom_el, action)
  }
  else if(action.type === IDK_ActionType.SnapElementToggle)
  {
    if(dom_el.ui_status & UI_Status.Locked)
    {
      UI_ActionSnap(dom_el, action)
    }
    else
    {
      UI_ActionSnap(dom_el, action)
    }
  }
  if(action.extra_after)
  {
    links = action.extra_after(dom_el, action);
  }
}

function UI_AddElement(dom_el: DOM_Element, types: bigint): DOM_Element|null
{
  let added: DOM_Element|null = null;
  if(types & DOM_ElementTypes_ScrollerToView)
  {
    const scroll_to_view = DOM_PushElem(null, DOM_ElementTypes_ScrollerToView, []);
    scroll_to_view.el.style.cursor = "pointer"
    DOM_AppendElement(scroll_to_view, dom_el, DOM_AppendType.LastChild)
    DOM_ElementPushActions(scroll_to_view, 
    [
      {extra_after: null, extra_before: null, on_types: DOM_ElementTypes_Context, event_type: EVENT_Type.MouseClick, selects: DOM_SelectTypes_Self, type: IDK_ActionType.ScrollTo, event: {} as IDK_EventListener },
    ]);
    IDK_StartListeners(scroll_to_view);
    added = scroll_to_view;
  }
  return added;
}

function IDK_FilterLinksFromType(links: UI_ElementLink[], types: bigint):UI_ElementLink[]
{
  const result:UI_ElementLink[] = [];
  for(let idx = 0; idx < links.length; idx += 1)
  {
    const link: UI_ElementLink = links[idx];
    if(link.dom_el.types & types)
    {
      result.push(link);
    }
  }
  return result;
}

function UI_ActionSnap(dom_el: DOM_Element, action: IDK_Action)
{
  // NOTE: the trigger is not the target where it will be Snaped, we use trigger's links to iterate over the child links and see if we found a Snap
  if(action.extra_before)
  {
    action.extra_before(dom_el, action);
  }
  UI_SetTransitionDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.Displayed|UI_Status.Locked|UI_Status.Selected, UI_Time.Short, UI_Time.NULL, UI_TransitionType.Linear);  
  if(action.extra_after)
  {
    action.extra_after(dom_el, action);
  }
}

function UI_ActionUnSnap(dom_el: DOM_Element, action: IDK_Action)
{
  
  for(let idx = 0; idx < dom_el.links.length; idx += 1)
  {
    const link: UI_ElementLink = dom_el.links[idx];
    if(link.type === UI_ElementLinkType.TriggerForSnap)
    {
      UI_SetDisplay(link.dom_el, DOM_SelectTypes_Self, UI_Status.UnSelected|UI_Status.Unlocked, UI_StatusNotFlags.NONE);
    }
  }
  UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.UnSelected|UI_Status.Unlocked, UI_StatusNotFlags.NotLocked);
  DOM_Remove(dom_el, UI_StatusNotFlags.NONE)
}

function UI_ActionDisappear(dom_el: DOM_Element, selects: bigint)
{
  if(DOM_Remove(dom_el, UI_StatusNotFlags.NotLocked))
  {
    UI_SetDisplay(dom_el, DOM_SelectTypes_Self, UI_Status.Hidden, UI_StatusNotFlags.NONE);
  }
}

function UI_ActionHighlight(dom_el: DOM_Element, selects: bigint)
{
    UI_SetDisplay(dom_el, selects, UI_Status.Highlighted, UI_StatusNotFlags.NONE);
}

function UI_ActionUnHighlight(dom_el: DOM_Element, selects: bigint)
{
  UI_SetDisplay(dom_el, DOM_SelectTypes_All, UI_Status.UnHighlighted, UI_StatusNotFlags.NONE);
}

function UI_ActionUnSelect(dom_el: DOM_Element, selects: bigint)
{
  if(selects & DOM_SelectTypes_Self)
  {
    UI_SetDisplay(dom_el, DOM_SelectTypes_All, UI_Status.UnSelected, UI_StatusNotFlags.NONE);
  }
  for(let idx = 0; idx < dom_el.links.length; idx += 1)
  {
    const linked_dom_el: UI_ElementLink = dom_el.links[idx];
    if(linked_dom_el.type === UI_ElementLinkType.Display)
    {
      UI_SetDisplay(dom_el, DOM_SelectTypes_All, UI_Status.UnSelected, UI_StatusNotFlags.NONE);
    }
  }
}

function UI_ActionSelected(dom_el: DOM_Element, selects: bigint)
{
  if(selects & DOM_SelectTypes_Self)
  {
    UI_SetDisplay(dom_el, DOM_SelectTypes_All, UI_Status.Selected, UI_StatusNotFlags.NONE);
  }
  for(let idx = 0; idx < dom_el.links.length; idx += 1)
  {
    const linked_dom_el: UI_ElementLink = dom_el.links[idx];
    if(linked_dom_el.type === UI_ElementLinkType.Display)
    {
      UI_SetDisplay(dom_el, DOM_SelectTypes_All, UI_Status.Selected, UI_StatusNotFlags.NONE);
    }
  }
}

///////////////////////////////////////////////////
// Action Tooltip

function IDK_ActionToolTip(event: Event, dom_el: DOM_Element, action: IDK_Action)
{
  // NOTE: we do not allowed multiple tooltip displayed on the screen (better UX)
  if(action.event_type == EVENT_Type.MouseEnter)
  {
    for(let idx = 0; idx < dom_el.links.length; idx += 1)
    {
      const link = dom_el.links[idx];
      if(link.type === UI_ElementLinkType.LinkSnapToParent)
      {
        DOM_AppendElement(link.dom_el, dom_el, DOM_AppendType.LastChild)
        UI_SetDisplay(link.dom_el, DOM_SelectTypes_Self, UI_Status.Displayed, UI_StatusNotFlags.NONE)
        // UI_ModifyStyleDefault(link.dom_el, DOM_ElementTypes_ToolTip)
        link.dom_el.el.style.position = "fixed"
        link.dom_el.el.style.top =  `${mouseY-10}px`;
        link.dom_el.el.style.left =  `${mouseX}px`;
        link.dom_el.el.style.userSelect = "none"
      }
    }
  }
  if(action.event_type == EVENT_Type.MouseLeave)
  {
    UI_ApplyAction(UI_ActionDisappear, dom_el, action);
  }
}
///////////////////////////////////////////////////
// action scroll to

function IDK_ActionPutScrollTo(event: Event, dom_el: DOM_Element, action: IDK_Action)
{
  
  event.preventDefault();
  UI_ApplyAction(UI_ActionScrollView, dom_el, action);
}

function UI_ActionScrollView(dom_el: DOM_Element, selects: bigint)
{
  // const pos = dom_el.el.getBoundingClientRect().top + window.scrollY + UI_DIM_TOP_BAR.y + 2000;
  window.scrollTo({ behavior: 'smooth',});
  UI_SetTransitionDisplay(dom_el, DOM_SelectTypes_All, UI_Status.Highlighted, UI_Time.Short, UI_Time.Short, UI_TransitionType.Linear);
}

///////////////////////////////////////////////////
// action hover visuals

function IDK_ActionPutVisualsHighligh(event: Event, dom_el: DOM_Element, action: IDK_Action)
{
  if(action.event_type == EVENT_Type.MouseClick)
  {
    if(dom_el.ui_status & UI_Status.Highlighted)
    {    
      UI_ApplyAction(UI_ActionUnHighlight, dom_el, action);
      UI_UnHighlight(dom_el);
    }
    else
    {
      UI_ApplyAction(UI_ActionHighlight, dom_el, action);
      UI_Highlight(dom_el);
    }
  }
  if(action.event_type == EVENT_Type.MouseEnter)
  {
    UI_ApplyAction(UI_ActionHighlight, dom_el, action);
  }
  else if(action.event_type == EVENT_Type.MouseLeave)
  {
    UI_ApplyAction(UI_ActionUnHighlight, dom_el, action);
  }
}
function IDK_ActionPutVisualsUnselected(event: Event, dom_el: DOM_Element, action: IDK_Action)
{
  if(action.event_type == EVENT_Type.MouseEnter)
  {
    UI_ApplyAction(UI_ActionSelected, dom_el, action);
  }
  else if(action.event_type == EVENT_Type.MouseLeave)
  {
    UI_ApplyAction(UI_ActionUnSelect, dom_el, action);
  }
}
///////////////////////////////////////////////////
// action Pressed visuals

function IDK_ActionPutPressed(event: Event, dom_el: DOM_Element, action: IDK_Action)
{
  if(action.type == IDK_ActionType.PressedHold)
  {
    for(let idx = 0; idx < dom_el.links.length; idx += 1)
    {
      const linked_dom_el: UI_ElementLink = dom_el.links[idx]; 
      UI_SetDisplay(linked_dom_el.dom_el, DOM_SelectTypes_All, UI_Status.UnSelected, UI_StatusNotFlags.NotLocked);
    }
  }
  else if(action.type == IDK_ActionType.Pressed)
  {
    for(let idx = 0; idx < dom_el.links.length; idx += 1)
    {
      const linked_dom_el: UI_ElementLink = dom_el.links[idx]; 
      UI_SetDisplay(linked_dom_el.dom_el, DOM_SelectTypes_All, UI_Status.Selected, UI_StatusNotFlags.NotLocked);
    }    
  }
}
///////////////////////////////////////////////////
// action Copy
// 
// function UI_CopyContent(dom_el: DOM_Element, selects: DOM_SelectTypes)
// {
//   dom_el.text.push(dom_el.el.innerText+ '\n');
// }


function IDK_ActionCopy(event: Event, dom_el: DOM_Element, action: IDK_Action)
{
  const text: string[] = [];
  const links: UI_ElementLink[] = [];
  if(action.selects &  DOM_SelectTypes_AllParentChildrens)
  {
    const parent_dom_el = UIGLOBAL_GetElement(dom_el.el.parentElement);
    if(parent_dom_el !== null)
    {
      links.push(...IDK_LinkByLinkTypes(parent_dom_el, UI_ElementLinkType.CopyText));
    }
  }
  if(action.selects &  DOM_SelectTypes_All)
  {
    links.push(...IDK_LinkByLinkTypes(dom_el, UI_ElementLinkType.CopyText));
  }
  for(let idx = 0; idx < links.length; idx += 1)
  {
    UI_SetDisplay(dom_el.links[idx].dom_el, DOM_SelectTypes_Self, UI_Status.Selected, UI_StatusNotFlags.NONE);
    // TODO: context does not have UI_DefaultStyle code path, not sure if we need it
    if(!(dom_el.links[idx].dom_el.types & DOM_ElementTypes_Icon) &&
       !(dom_el.links[idx].dom_el.types & DOM_ElementTypes_IconInlined))
    {
      
      // dom_el.links[idx].dom_el.el.style.fontWeight = "800"
      text.push(links[idx].dom_el.el.innerText + '\n');
      // UI_SetDisplay(dom_el.links[idx].dom_el, DOM_SelectTypes_Self, UI_Status.Selected, UI_StatusNotFlags.NONE);
    }
  }
  navigator.clipboard.writeText(
      text.join("\n")
  ).then(() => {
  }).catch(_ => {});
  
  setTimeout(() => {
    // NOTE: let browser time to add transition before it render the frame
    if(dom_el.types & DOM_ElementTypes_Icon || 
      dom_el.types & DOM_ElementTypes_IconInlined)
   {
    for(let idx = 0; idx < links.length; idx += 1)
    {
      // TODO: context does not have UI_DefaultStyle code path, not sure if we need it
      if(!(dom_el.links[idx].dom_el.types & DOM_ElementTypes_Icon) &&
      !(dom_el.links[idx].dom_el.types & DOM_ElementTypes_IconInlined))
      {
        dom_el.links[idx].dom_el.el.style.fontWeight = "500"
        // text.push(links[idx].dom_el.el.innerText+ '\n');
        // UI_SetDisplay(dom_el.links[idx].dom_el, DOM_SelectTypes_Self, UI_Status.UnSelected, UI_StatusNotFlags.NONE);
      }
    }
    }
  }, 100);
} 

///////////////////////////////////////////////////
// action Wipe

function UI_ReplicateAction(func: (...args: any[]) => any, event: Event, action: IDK_Action, dom_elements: DOM_Element[])
{
  for(let idx = 0; idx < dom_elements.length; idx += 1)
  {
    func(event, dom_elements[idx], action); 
  }
}

function IDK_ActionPutWipeAll(event: Event, dom_el: DOM_Element, action: IDK_Action)
{
  for(let idx = 0; idx < dom_el.links.length; idx += 1)
  {
    const linked_dom_el: UI_ElementLink = dom_el.links[idx]; 
    if(DOM_Remove(linked_dom_el.dom_el, UI_StatusNotFlags.NONE))
    {
    }
  }
}

function DOM_DOMTypesFromHTMLElement(el: HTMLElement): bigint
{
  let result: bigint = DOM_ElementTypes_NULL;
  if(el instanceof SVGSVGElement)
  {
    result = DOM_ElementTypes_SVG;
  }
  else if(el instanceof SVGPathElement)
  {
    result = DOM_ElementTypes_Path;
  }
  return result;
}

function DOM_SetAttributesRec(el: any, selects: bigint, keys: string[], values: string[])
{
  if(selects & DOM_SelectTypes_All ||
     selects & DOM_SelectTypes_Self)
  {
   const types = DOM_DOMTypesFromHTMLElement(el)
   if(types & selects)
    {
      for(let idx = 0; idx < keys.length; idx += 1)
      {
        el.setAttribute(keys[idx], values[idx]);
      }
    }
  }
  if(selects & DOM_SelectTypes_All          ||
     selects & DOM_SelectTypes_AllChildrens)
  {
    for(let child_idx = 0; 
      child_idx < el.childNodes.length; 
      child_idx += 1)
    {
        for(let idx = 0; idx < keys.length; idx += 1)
        {
          const child = el.childNodes[child_idx];
          DOM_SetAttributesRec(child, selects|DOM_SelectTypes_Self, keys, values);
      }
    }
  }
}

function UI_CanModify(status: UI_Status, status_not: UI_StatusNotFlags): boolean
{
  let result = true;
  const is_locked      = status & UI_Status.Locked;
  const is_selected    = status & UI_Status.Selected;
  const is_displayed   = status & UI_Status.Displayed;
  const is_highlighted = status & UI_Status.Highlighted;
  
  if(is_locked       && status_not & UI_StatusNotFlags.NotLocked     ||
      is_selected    && status_not & UI_StatusNotFlags.NotSelected   ||
      is_displayed   && status_not & UI_StatusNotFlags.NotDisplayed  ||
      is_highlighted && status_not & UI_StatusNotFlags.NotHighlighted)
  {
    result = false;
  }
  return result;
}

function AlphaCount(text, cap) 
{
  let result = 0 
  if (!text) return result; 
  for (let idx = 0; idx < text.length; idx++) 
  {
    const char = text[idx];
    if(char >= 'a' && char <= 'z' || char >= 'A' && char <= 'Z') 
    {
      result += 1;
      if(cap === result)
      {
        break;
      }
    }
  }
  return result; 
}

function IDK_DeriveType(el: HTMLElement|SVGSVGElement): bigint
{
  let result = 0n;
  for(let idx = 1n; idx < 64n; idx += 1n)
  {
    const str = IDK_HTMLStringFromKind((1n << idx));
    if(str && el.id.includes(str))
    {
      result = (1n << idx);
      break;
    }
  }
  if(result == 0n)
  {
    if(el instanceof HTMLParagraphElement)
      {
        result = DOM_ElementTypes_Text;
      }
      else if(el instanceof HTMLAnchorElement)
      {
        result = DOM_ElementTypes_Link;
      }
      else if(el instanceof HTMLDivElement)
      {
        result = DOM_ElementTypes_Container;
      }
      else if(el instanceof HTMLSpanElement)
      {
        result = DOM_ElementTypes_Span;
      }
      else if(el instanceof HTMLHeadingElement && 
        el.tagName === "H1")
      {
        result = DOM_ElementTypes_Heading1;
      }
      else if(el instanceof HTMLHeadingElement && 
        el.tagName === "H2")
      {
        result = DOM_ElementTypes_Heading2;
      }
      else if(el instanceof HTMLHeadingElement && 
        el.tagName === "H3")
      {
        result = DOM_ElementTypes_Heading3;
      }
      else if(el instanceof HTMLHeadingElement && 
        el.tagName === "H4")
      {
        result = DOM_ElementTypes_Heading4;
      }
      else if(el instanceof HTMLHeadingElement && 
        el.tagName === "H5")
      {
        result = DOM_ElementTypes_Heading5;
      }
      else if(el instanceof HTMLTableElement)
      {
        result = DOM_ElementTypes_Table;
      }
      else if(el instanceof HTMLTimeElement)
      {
        result = DOM_ElementTypes_Time;
      }
      else if(el instanceof HTMLTableRowElement)
      {
        result = DOM_ElementTypes_TableEntry;
      }
      else if(el instanceof HTMLImageElement)
      {
        result = DOM_ElementTypes_Image;
      }
      else if(el instanceof SVGSVGElement)
      {
        result = DOM_ElementTypes_Icon;
        result = DOM_ElementTypes_SVG;
      }
    }
  return result;
}

function DOM_AddIDAndClasses(el: HTMLElement, class_and_ids: string[])
{
  const class_names = class_and_ids.filter(name => name.startsWith('.')).map(name => name.substring(1));
  const id_name = class_and_ids.filter(name => name.startsWith('#')).map(name => name.substring(1))[0];
  if(class_names.length != 0)
  {
    el.classList.add(...class_names);
  }
  if(id_name)
  {
    el.id = id_name;
  }
}

function _DOM_PureHTMLElement(types: bigint): HTMLElement
{
  const names: string[] = [];
  let el: HTMLElement|null = null;
  const classes: string[] = [];
  if(types & DOM_ElementTypes_Data)
  {
    names.push("div");
    classes.push(".data")
  }
  if(types & DOM_ElementTypes_ToolTip)
  {
    names.push("span");
    classes.push(".tooltip")
  }
  if(types & DOM_ElementTypes_Trigger)
  {
    names.push("button");
    classes.push(".trigger")
  }
  if(types & DOM_ElementTypes_Container)
  {
    names.push("div");
    classes.push(".container")
  }
  if(types & DOM_ElementTypes_IconInlined ||
    types & DOM_ElementTypes_Icon)
  {
    names.push("svg");
    classes.push(".icon_inlined")
  }
  if(types & DOM_ElementTypes_BrokenLink)
  {
    names.push("span");
    classes.push(".broken_link")
  }
  if(types & DOM_ElementTypes_NULL)
  {
    names.push("span");
  }
  if(names.length === 0)
  {
    names.push("div")
  }
  el = document.createElement(names[0]);
  DOM_AddIDAndClasses(el, classes);
  return el;
}

function DOM_ReplaceElement(el: DOM_Element, to_replace: DOM_Element)
{
  to_replace.el?.parentElement?.replaceChild(el.el, to_replace.el);
  DOM_Remove(to_replace, UI_StatusNotFlags.NONE);
}

function DOM_PushElem(el:          HTMLElement|null,
                      types:       bigint,
                      classes_ids: string[]): DOM_Element
{
  let dom_el = UIGLOBAL_GetElement(el);
  if(dom_el === null)
  {
    if(el === null)
    {
      el = _DOM_PureHTMLElement(types);
    }
    if(types & DOM_ElementTypes_Trigger)
    {
      types |= DOM_ElementTypes_Selectable;
    }
    DOM_AddIDAndClasses(el, classes_ids);
    dom_el = 
    {
      actions: [],
      idx: ui_global.dom_elements.length,
      append: DOM_AppendType.LastChild,
      links: [],
      types: types,
      el: el,
      ui_status: UI_Status.Displayed
    };
    // TODO: check duplicates ?
    ui_global.dom_elements.push(dom_el);
    // UI_ModifyStyleDefault(dom_el, dom_el.types);
    if(dom_el.types & DOM_ElementTypes_ToolTip)
    {
      // NOTE: We can have several HTMLElements inside the tooltip which should not entirely follow the normal styling and behavior compared to when it is part of the text content
      for(let idx = 0; idx < el.childNodes.length; idx += 1)
      {
        const child_n = el.childNodes[idx] as HTMLElement
        if (child_n instanceof HTMLElement) 
        {
          const child_types = IDK_DeriveType(child_n);
          if(child_types & DOM_ElementTypes_Link)
          {
          }
          const child_dom_el = DOM_PushElem(child_n, child_types, []);
          child_dom_el.el.style.fontFamily = dom_el.el.style.fontFamily
          child_dom_el.el.style.fontSize = dom_el.el.style.fontSize
          child_dom_el.el.style.fontWeight = dom_el.el.style.fontWeight
          child_dom_el.el.style.borderBottomWidth = "1px"
          child_dom_el.el.style.borderTopWidth = "0"
          child_dom_el.el.style.borderRightWidth = "0"
          child_dom_el.el.style.borderLeftWidth = "0"
          child_dom_el.el.style.borderColor = "#b3b2af"
          child_dom_el.el.style.borderStyle = "solid"
        }
      }
    }
  }
  return dom_el;
}
// }

function UIGLOBAL_GetElement(el: HTMLElement|null): DOM_Element|null
{
  let result: DOM_Element|null = null;
  if(el !== null)
  {
    for(let idx = 0; idx < ui_global.dom_elements.length; idx += 1)
    {
      if(ui_global.dom_elements[idx].el === el)
      {
        result = ui_global.dom_elements[idx];
        break;
      }
    }
  }
  return result;
}

function UIGLOBAL_GetElementByTypes(types: bigint): DOM_Element|null
{
  let result: DOM_Element|null = null;
  for(let idx = 0; idx < ui_global.dom_elements.length; idx += 1)
  {
    if(ui_global.dom_elements[idx].types & types)
    {
      result = ui_global.dom_elements[idx];
      break;
    }
}
  return result;
}

function UIGLOBAL_GetElementById(id: string): DOM_Element|null
{
  let result: DOM_Element|null = null;
  for(let idx = 0; idx < ui_global.dom_elements.length; idx += 1)
  {
    if(ui_global.dom_elements[idx].el.id === id)
    {
      result = ui_global.dom_elements[idx];
      break;
    }
  }
  return result;
}

function UIGLOBAL_HasElement(el: HTMLElement|null): boolean
{
  let result = false;
  if(el !== null)
  {
    for(let idx = 0; idx < ui_global.dom_elements.length; idx += 1)
    {
      if(ui_global.dom_elements[idx].el === el)
      {
        result = true;
        break;
      }
    }
  }
  return result;
}

function CSS_CatRules(keys: string[], values: string[] | number[]): string
{
  const css_rules:string[] = [];
  if(keys.length != values.length) debugger
  for(let idx = 0; idx < keys.length; idx += 1)
  {
    let value = values[idx];
    if(typeof value === 'number')
    {
      value.toString()
    }
    css_rules.push(keys[idx]+':'+value+';');
  }
  return css_rules.join("");
}

function UI_PushLink(dom_el: DOM_Element, link: DOM_Element, type: UI_ElementLinkType)
{
  dom_el.links.push({relation: DOM_RelationType.Parent, dom_el: link, type: type});
  link.links.push({relation: DOM_RelationType.Child, dom_el: dom_el, type: type});
}

function _UI_UnsetTransition(el: HTMLElement)
{
  el.style.transition = '';
}

function UI_SetTransitionDisplay(dom_el: DOM_Element, selects: bigint, 
                                to: UI_Status,
                                duration: UI_Time,
                                delay: UI_Time,
                                transition_type: UI_TransitionType)
{
  // NOTE: opacity and transform are GPU accelerated
  // TODO: so we need to create an element with opacity 0 behind it then 100 later
  let duration_ms = 0;
  let delay_ms = 0;
  if(duration === UI_Time.Long)
  {
    duration_ms = 0.5;
  }
  else if(duration === UI_Time.Normal)
  {
    duration_ms = 0.3;
  }
  else if(duration === UI_Time.Short)
  {
    duration_ms = 0.04;
  }
  if(delay === UI_Time.Long)
  {
    delay_ms = 0.5;
  }
  else if(delay === UI_Time.Normal)
  {
    delay_ms = 0.2;
  }
  else if(delay === UI_Time.Short)
  {
    delay_ms = 0.1;
  }  
  dom_el.el.style.transitionDuration = duration_ms.toString()+'s';
  dom_el.el.style.transitionDelay = delay_ms.toString()+'s';
  dom_el.el.style.transitionProperty = "background-color"
  switch(transition_type)
  {
    case UI_TransitionType.Ease:
    {
      dom_el.el.style.transitionTimingFunction = "ease";
    } break;
    case UI_TransitionType.Linear:
    {
      dom_el.el.style.transitionTimingFunction = "linear";
    } break;
    case UI_TransitionType.EaseOut:
    {
      dom_el.el.style.transitionTimingFunction = "ease-out";
    } break;
    case UI_TransitionType.EaseIn:
    {
      dom_el.el.style.transitionTimingFunction = "ease-in";
    } break;
    case UI_TransitionType.EaseInOut:
    {
      dom_el.el.style.transitionTimingFunction = "ease-in-out";
    } break;
    default: 
    {
      dom_el.el.style.transitionTimingFunction = "linear";
    } break
  }
  setTimeout(() => {
    // NOTE: let browser time to add transition before it render the frame
    UI_SetDisplay(dom_el, selects, to, UI_StatusNotFlags.NONE);
  }, 0);
  const unset_ms = (duration_ms*1000)+(delay_ms*1000)+500 // TODO: does not work, it seems that css time is not the real one
  setTimeout(() => {
    _UI_UnsetTransition(dom_el.el)
  }, 3000);
}

function NodeRecDepthFirstPre(el: any): HTML_ElementRec
{
  // TODO: next should never be null, this is not a complete tree traversal algorithm
  let rec: HTML_ElementRec = {} as HTML_ElementRec;
  rec.next = null;
  rec.prev = el;
  rec.pop_count = 0;
  rec.push_count = 0; 
  for(let idx = 0; idx < el.childNodes.length; idx += 1)
  {
    const child_el = el.childNodes[idx];
   if (child_el.nodeType !== Node.TEXT_NODE) 
   {
     rec.next = child_el;
     rec.push_count = 1;
   }
  }
  if(rec.next === null)
  {
    for(let p = el; 
            p != null && p != undefined; 
            p = p.parentElement as HTMLElement)
    {
      if(p.nextElementSibling && 
        p.nextElementSibling instanceof HTMLElement ||
        p.nextElementSibling instanceof SVGSVGElement)
      {
        rec.next = p.nextElementSibling;
        break;
      }
      rec.pop_count += 1;
    }
  }
  return rec;
}

function DOM_StyleRec(el:HTMLElement, keys: string[], values: string[])
{
  
  for(let n: HTMLElement = el, next: HTMLElement = el; 
    next != null && n != null;
    n = next)
  {
    const rec: HTML_ElementRec  = NodeRecDepthFirstPre(n);
    const css_rules_text = CSS_CatRules(keys, values);
    n.style.cssText += css_rules_text;
    if(rec.next != null)
    {
      next = rec.next;
    }
    else
    {
      break;
    }
  }
}

function IDK_HTMLStringFromKind(DOM_ElementType: bigint): string
{
  let result = "";
  switch(DOM_ElementType)
  {
    case DOM_ElementTypes_ContextDocument:
    {
      result = "cod_";
    } break;
    case DOM_ElementTypes_Context:
    {
      result = "co_";
    } break;
    case DOM_ElementTypes_Heading1:
    case DOM_ElementTypes_Heading2:
    case DOM_ElementTypes_Heading3:
    case DOM_ElementTypes_Heading4:
    case DOM_ElementTypes_Heading5:
    {
      result = "he_";
    } break;
    case DOM_ElementTypes_Quote:
    {
      result = "quo_";
    } break;
    case DOM_ElementTypes_Block:
    {
      result = "bl_";
    } break;
    case DOM_ElementTypes_Paragraph:
    {
      result = "pa_";
    } break;
    case DOM_ElementTypes_List:
    {
      result = "l_";
    } break;
    case DOM_ElementTypes_Table:
    {
      result = "t_";
    } break;
    case DOM_ElementTypes_TableEntry:
    {
      result = "te_";
    } break;
    case DOM_ElementTypes_CKeyword:
    {
      result = "cor_";
    } break;
    case DOM_ElementTypes_Footnote:
    {
      result = "fo_";
    } break;
    case DOM_ElementTypes_FootnoteReference:
    {
      result = "for";
    } break;
    case DOM_ElementTypes_InternalLink:
    {
      result = "inl";
    } break;
    case DOM_ElementTypes_FileLink:
    {
      result = "li_f";
    } break;
    case DOM_ElementTypes_BrokenLink:
    {
      result = "li_http";
    } break;
    case DOM_ElementTypes_HTTPLink:
    {
      result = "b_link";
    } break;
    case DOM_ElementTypes_Body:
    {
      result = "b_w";
    } break;
    case DOM_ElementTypes_InternalLinkReference:
    {
      result = "inl_ref";
    } break;
    case DOM_ElementTypes_TOC:
    {
      result = "toc";
    } break;
    case DOM_ElementTypes_TOCItem:
    {
      result = "toc_i_";
    } break;
    default: {};
  }
  return result;
}


/////////////////////////////////////
// end 

///////////////////////////////////////////
// NOTE: internal DOM_Element types (two flags type are correlated, bit values must match !)

// SELECT types
const DOM_SelectTypes_NULL                      = 0n;
const DOM_SelectTypes_AllData                   = 1n << 1n;
const DOM_SelectTypes_AllTrigger                = 1n << 2n;
const DOM_SelectTypes_AllContainer              = 1n << 3n;
const DOM_SelectTypes_AllSelectable             = 1n << 4n;
const DOM_SelectTypes_AllCheckbox               = 1n << 5n;
const DOM_SelectTypes_AllTopMost                = 1n << 6n;
const DOM_SelectTypes_AllScrollToView           = 1n << 7n;
const DOM_SelectTypes_AllContextTextNotDocument = 1n << 8n | 1n << 9n;
const DOM_SelectTypes_ContextDocument           = 1n << 10n;
const DOM_SelectTypes_AllImage                  = 1n << 11n;
const DOM_SelectTypes_AllLink                   = 1n << 12n;
const DOM_SelectTypes_AllToolTip                = 1n << 13n;
const DOM_SelectTypes_AllText                   = 1n << 14n;
const DOM_SelectTypes_AllTopBar                 = 1n << 15n;
const DOM_SelectTypes_AllBody                   = 1n << 16n;
const DOM_SelectTypes_AllBrokenLink             = 1n << 17n;
const DOM_SelectTypes_AllIcon                   = 1n << 18n | 2n << 19n;
const DOM_SelectTypes_AllQuote                  = 1n << 20n;
const DOM_SelectTypes_AllHeading1               = 1n << 21n;
const DOM_SelectTypes_AllHeading2               = 1n << 22n;
const DOM_SelectTypes_AllHeading3               = 1n << 23n;
const DOM_SelectTypes_AllHeading4               = 1n << 24n;
const DOM_SelectTypes_AllHeading5               = 1n << 25n;
const DOM_SelectTypes_AllHeadings               = (1n << 21n || 1n << 22n || 1n << 23n || 1n << 24n || 1n << 25n);
const DOM_SelectTypes_AllTable                  = 1n << 26n;
const DOM_SelectTypes_AllTableEntry             = 1n << 27n;
const DOM_SelectTypes_AllSpan                   = 1n << 28n;
const DOM_SelectTypes_AllSVG                    = 1n << 29n;
const DOM_SelectTypes_AllPath                   = 1n << 30n;
const DOM_SelectTypes_AllParentContext          = 1n << 31n;
const DOM_SelectTypes_AllTime                   = 1n << 32n;
const DOM_SelectTypes_All                       = 1n << 44n;
const DOM_SelectTypes_Self                      = 1n << 45n;
const DOM_SelectTypes_AllChildrens              = 1n << 46n;
const DOM_SelectTypes_AllParentChildrens        = 1n << 47n;

// ELEMENT types
const DOM_ElementTypes_NULL                     = 0n;
const DOM_ElementTypes_CKeyword   = 1n << 1n;
const DOM_ElementTypes_ContextDocument          = 1n << 2n;
const DOM_ElementTypes_Context                  = 1n << 3n;
const DOM_ElementTypes_Heading1                 = 1n << 4n;
const DOM_ElementTypes_Heading2                 = 1n << 5n;
const DOM_ElementTypes_Heading3                 = 1n << 6n;
const DOM_ElementTypes_Heading4                 = 1n << 7n;
const DOM_ElementTypes_Heading5                 = 1n << 8n;
const DOM_ElementTypes_InternalLink             = 1n << 9n;
const DOM_ElementTypes_InternalLinkReference    = 1n << 10n;
const DOM_ElementTypes_HTTPLink                 = 1n << 11n;
const DOM_ElementTypes_FileLink                 = 1n << 12n;
const DOM_ElementTypes_Footnote                 = 1n << 13n;
const DOM_ElementTypes_FootnoteReference        = 1n << 14n;
const DOM_ElementTypes_Link                     = 1n << 15n;
const DOM_ElementTypes_BrokenLink               = 1n << 16n;
const DOM_ElementTypes_Body                     = 1n << 17n;
const DOM_ElementTypes_Quote                    = 1n << 18n;
const DOM_ElementTypes_TOC                      = 1n << 19n;
const DOM_ElementTypes_TOCItem                  = 1n << 20n;
const DOM_ElementTypes_TopBar                   = 1n << 21n;
const DOM_ElementTypes_Paragraph                = 1n << 22n;
const DOM_ElementTypes_Table                    = 1n << 23n;
const DOM_ElementTypes_TableEntry               = 1n << 24n;
const DOM_ElementTypes_Time                     = 1n << 25n;
const DOM_ElementTypes_Data                     = 1n << 26n;
const DOM_ElementTypes_Trigger                  = 1n << 27n;
const DOM_ElementTypes_Container                = 1n << 28n;
const DOM_ElementTypes_Selectable               = 1n << 29n;
const DOM_ElementTypes_Checkbox                 = 1n << 30n;
const DOM_ElementTypes_TopMost                  = 1n << 31n;
const DOM_ElementTypes_ScrollerToView           = 1n << 32n;
const DOM_ElementTypes_Block                    = 1n << 33n;
const DOM_ElementTypes_Image                    = 1n << 34n;
const DOM_ElementTypes_ToolTip                  = 1n << 35n;
const DOM_ElementTypes_Text                     = 1n << 36n;
const DOM_ElementTypes_IconInlined              = 1n << 37n;
const DOM_ElementTypes_Icon                     = 1n << 38n;
const DOM_ElementTypes_List                     = 1n << 39n;
const DOM_ElementTypes_Span                     = 1n << 40n;
const DOM_ElementTypes_SVG                      = 1n << 41n;
const DOM_ElementTypes_Path                     = 1n << 42n;
const DOM_ElementTypes_ParentContext            = 1n << 43n;
const DOM_ElementTypes_NoStyle                  = 1n << 44n;
const DOM_ElementTypes_COUNT                    = 1n << 63n;

const enum IDK_ActionType
{
  NULL,
  CopyText,     
  Overlay,
  WipeData,     
  WipeAll,     
  PopUpElement, 
  PopDownElement, 
  SnapElementToggle, 
  ToolTip,
  ScrollTo,
  Pressed,
  PressedHold,
  HoverVisualsHighlight,
  HoverVisualsSelected,
}

const enum EVENT_Type
{
  NULL,
  MouseEnter,
  MouseLeave,
  MouseClick,
  MouseRightClick
}

const enum UI_TransitionType
{
  NULL,
  Ease,
  EaseOut,
  EaseIn,
  EaseInOut,
  Linear
}

interface IDK_EventFunction
{
  func: (...args: any[]) => any;
}

interface UI_StyleElement
{
  border_radius:   number;   
  bg_color:             string;
  border_color:   string;
  border_top_width:   number;
  border_bottom_width:   number;
  border_left_width:   number;
  border_right_width:   number;
  border_style:   string;
  padding_top:    number;
  padding_left:   number;
  padding_right:  number;
  padding_bottom: number;
  font_size:      number;
  width:          number;
  height:         number;
  display:        string;
  position:       string
  flex_direction: string;
  top:            number;
  left:           number;
  color:          string;
  font_family:    string;
  text_decoration:string;
  font_weight:    number;
  list_style_type: string;
}

interface UI_StyleTheme
{
  button:       UI_StyleElement;
  container:    UI_StyleElement;
  tooltip:      UI_StyleElement
  context_doc:  UI_StyleElement
  top_bar:      UI_StyleElement
  body:         UI_StyleElement
  text:         UI_StyleElement;
  link:         UI_StyleElement;
  broken_link:  UI_StyleElement;
  icon_inlined: UI_StyleElement;
  root:         UI_StyleElement;
  top_left:     UI_StyleElement;
  top_right:    UI_StyleElement;
  bottom_left:  UI_StyleElement;
  bottom_right: UI_StyleElement;
  icon:         UI_StyleElement;
  heading1:     UI_StyleElement;
  heading2:     UI_StyleElement;
  heading3:     UI_StyleElement;
  heading4:     UI_StyleElement;
  heading5:     UI_StyleElement;
  block:        UI_StyleElement;
  toc_item:     UI_StyleElement;
  toc_container:UI_StyleElement;
}

const enum UI_PersistanceType
{
  NULL,
  WipeOnAssociation,
  Stay,
}

const enum IDK_KeeperTypes
{
  NULL,
  Context   = 1 << 1,
  Referer   = 1 << 2,
}

const enum DOM_AppendType 
{
  NULL,
  After,
  Before,
  FirstChild,
  LastChild,
}

const enum DOM_RelationType 
{
  NULL,
  Parent,
  Child,
}

const enum UI_Time 
{
  NULL,
  Short,
  Normal,
  Long,
}

const enum UI_StatusNotFlags 
{
  NONE            = 0,
  NotLocked       = 1 << 1,
  NotHighlighted  = 1 << 2,
  NotSelected     = 1 << 3,
  NotDisplayed    = 1 << 4,
}

const enum UI_Status 
{
  NULL,
  Displayed           = 1 << 1,
  Hidden              = 1 << 2,
  Locked              = 1 << 3,
  Unlocked            = 1 << 4,
  Selected            = 1 << 5,
  Highlighted         = 1 << 6,
  UnHighlighted       = 1 << 7,
  UnSelected          = 1 << 8,
  Orphan              = 1 << 9,
  UnOrphan            = 1 << 10,
}

const enum UI_ElementLinkType
{
  ParentSnapToLink,
  LinkSnapToParent,
  ChildLinkSnapToParent,
  TriggerForSnap,
  ScrollTo,
  Display,
  CopyText,
  CopyHref,
  Overlay,
}

const enum UI_IconType
{
  Clipboard,
  BrokenLink,
  InlineLink,
}

const enum IDK_TargetKind
{
    NULL,
    Trigger,
    Tooltip,
    Container,
    TopMost,
    Data,
}
////////////////////////
// UI Root

interface UI_Root
{
  root:          DOM_Element
  top_bar:       DOM_Element;
  top_left:      DOM_Element
  top_right:     DOM_Element
  bottom_left:   DOM_Element;
  bottom_right:  DOM_Element;
  dom_elements:  DOM_Element[];
}
/////////////////////////
// actions

interface IDK_EventListener
{
  func: ((...args: any[]) => any);
  type: EVENT_Type;
}

interface IDK_Action
{
  selects:    bigint;
  on_types:   bigint;
  type:       IDK_ActionType;
  event_type: EVENT_Type;
  event:      IDK_EventListener|null
  extra_before:      ((...args: any[]) => any)|null;
  extra_after:      ((...args: any[]) => any)|null;
}

interface UI_Tooltip
{
  tooltip_text:  string[];
  idxs_elements: number[];
  target: DOM_Element;
}

interface UI_ElementLink
{
  type:   UI_ElementLinkType;
  relation: DOM_RelationType
  dom_el: DOM_Element;
}

///////////////////////////////////////
// DOM 

interface HTML_ElementRec
{
  next: HTMLElement|null;
  prev: HTMLElement;
  pop_count: number;
  push_count: number;
}
interface DOM_Element
{
  idx:         number;
  // parent:      DOM_Element|null;
  append:      DOM_AppendType;
  actions:     IDK_Action[];
  types:       bigint
  el:          HTMLElement;
  ui_status:   UI_Status;
  links:       UI_ElementLink[];
  // idxs_child:  number[]
}
