if (sessionStorage.getItem("standard_script_version") != "1") {
    sessionStorage.setItem("standard_script_version", "1");
    const settings = {
        wp_url: window.location.href,
        pixelX: window.innerWidth,
        pixelY: window.innerHeight,
        mouseX: 0,
        mouseY: 0,
    };
    window.addEventListener("resize", () => { settings.pixelX = window.innerWidth; settings.pixelY = window.innerHeight; HTTP_GetCorrectHTMLFromScreenSize(window.location.href); });
    window.addEventListener("mousemove", (event) => { settings.mouseX = event.clientX; settings.mouseY = event.clientY; });
}
HTTP_GetCorrectHTMLFromScreenSize(window.location.href);
/////////////////////////////////////////////
// HTTP
function HTTP_GetCorrectHTMLFromScreenSize(url) {
    if (url.indexOf("_smartphone.html") === -1 &&
        (/android|webos|iphone|ipod|blackberry|windows phone|opera mini|opera mobi|mobile|tablet/i).test(navigator.userAgent)) {
        let filename = url.substring(url.lastIndexOf("https://axeldaguerre.com/") + 25);
        if (!filename) {
            // index page
            filename = "index.html";
        }
        const pos = filename.lastIndexOf(".html");
        if (pos !== -1) {
            filename = filename.substring(0, pos);
        }
        const url_sm = "https://axeldaguerre.com/" + filename + "_smartphone.html";
        fetch(url_sm, {
            method: "GET",
        })
            .then(response => response.text())
            .then(html => {
            document.open();
            document.write(html);
            document.close();
            window.location.href = url_sm;
            history.replaceState(null, '', url_sm);
        })
            .catch(error => console.error("Error fetching correct page:", error));
    }
}
