  //tsc "C:\Users\axeld\Documents\Projects\Projects_Programming\website_parser\build\local\shared\javascript\website\ui_immediate.ts" --skipLibCheck --module none --lib es2020,dom --target ES2020 --pretty falsefunction renderUI() {
  
  
const canvas = document.createElement("canvas");
document.body.appendChild(canvas);
canvas.width = window.innerWidth;
canvas.height = window.innerHeight;
const gl = canvas.getContext("webgl");

// Vertex Shader (positions of the button)
const vsSource = `
    attribute vec4 a_position;
    void main() {
        gl_Position = a_position;
    }
`;

// Fragment Shader (button color)
const fsSource = `
    precision mediump float;
    uniform vec4 u_color;
    void main() {
        gl_FragColor = u_color;
    }
`;

// Compile shader function
function compileShader(gl, source, type) {
    const shader = gl.createShader(type);
    gl.shaderSource(shader, source);
    gl.compileShader(shader);
    if (!gl.getShaderParameter(shader, gl.COMPILE_STATUS)) {
        console.error(gl.getShaderInfoLog(shader));
        return null;
    }
    return shader;
}

// Create shaders
const vertexShader = compileShader(gl, vsSource, gl.VERTEX_SHADER);
const fragmentShader = compileShader(gl, fsSource, gl.FRAGMENT_SHADER);

// Create program
const program = gl.createProgram();
gl.attachShader(program, vertexShader);
gl.attachShader(program, fragmentShader);
gl.linkProgram(program);
gl.useProgram(program);

// Create a square (button)
const buttonVertices = new Float32Array([
    -0.5, -0.2,   // Bottom-left
     0.5, -0.2,   // Bottom-right
    -0.5,  0.2,   // Top-left
     0.5,  0.2    // Top-right
]);

// Create buffer
const buffer = gl.createBuffer();
gl.bindBuffer(gl.ARRAY_BUFFER, buffer);
gl.bufferData(gl.ARRAY_BUFFER, buttonVertices, gl.STATIC_DRAW);

// Get attribute location
const position = gl.getAttribLocation(program, "a_position");
gl.enableVertexAttribArray(position);
gl.vertexAttribPointer(position, 2, gl.FLOAT, false, 0, 0);

// Get uniform location for color
const colorLocation = gl.getUniformLocation(program, "u_color");

// Draw function
function render() {
    gl.clearColor(0, 0, 0, 1);
    gl.clear(gl.COLOR_BUFFER_BIT);

    // Change color on hover (not perfect)
    let mouseX = (lastMouseX / canvas.width) * 2 - 1;
    let mouseY = -(lastMouseY / canvas.height) * 2 + 1;
    let isHovered = mouseX > -0.5 && mouseX < 0.5 && mouseY > -0.2 && mouseY < 0.2;

    gl.uniform4f(colorLocation, isHovered ? 0.8 : 0.5, 0.5, 1.0, 1.0);
    
    gl.drawArrays(gl.TRIANGLE_STRIP, 0, 4);

    requestAnimationFrame(render);
}

// Handle mouse movement for interaction
let lastMouseX = 0, lastMouseY = 0;
canvas.addEventListener("mousemove", (e) => {
    lastMouseX = e.clientX;
    lastMouseY = e.clientY;
});

// Start rendering
render();
