/////////////////////////////////////////
// avoid error when script is loaded multiple times (variable already set)

const GlobalConfig = (() => {
  const config = {
    DEV_MODE: typeof config?.DEV_MODE !== "undefined" 
      ? config.DEV_MODE 
      : window.location.href.startsWith("file:///"),

    GLB_domain: typeof config?.GLB_domain !== "undefined" 
      ? config.GLB_domain 
      : "https://axeldaguerre.com/",

    WEB_PAGE_URL: typeof config?.WEB_PAGE_URL !== "undefined" 
      ? config.WEB_PAGE_URL 
      : window.location.href,

    GLB_mouseX: 0,
    GLB_mouseY: 0,
    GLB_pixelX: 0,
    GLB_pixelY: 0,
  };

  return {
    get: (key: keyof typeof config) => config[key],
    set: (key: keyof typeof config, value: any) => config[key] = value
  };
})();

// Example Usage:
console.log(GlobalConfig.get("DEV_MODE")); // Check DEV_MODE
GlobalConfig.set("GLB_mouseX", 100); // Set a value
console.log(GlobalConfig.get("GLB_mouseX")); // Retrieve the value
